
<?php $__env->startSection('title', __('Invest Dashboard')); ?>

<?php 
    use App\Enums\InvestmentStatus;
    use Illuminate\Support\Arr;

    $currency = base_currency();

    $plans = [];
    $renderIvGraph = !empty($ivGraph) && array_sum($ivGraph) > 0;
    $renderTopSchemeGraph = !empty($topSchemeGraph) && array_sum($topSchemeGraph) > 0;

    foreach ($activePlans as $name => $data) {
        $plans['name'][] = $name;
        $plans['colors'][] = $data['color'];
        $plans['data'][] = $data['count'];
    }
?>

<?php $__env->startSection('content'); ?>
<div class="nk-content-body">
    <div class="nk-block-head nk-block-head-sm">
        <div class="nk-block-between g-3">
            <div class="nk-block-head-content">
                <h3 class="nk-block-title page-title"><?php echo e(__("Investment Insight")); ?></h3>
                <div class="nk-block-des text-soft">
                    <p><?php echo e(__("Here is an insight of what's going on.")); ?></p>
                </div>
            </div>
            <div class="nk-block-head-content">
                <a href="<?php echo e(route('admin.investment.list')); ?>" class="btn btn-primary d-none d-sm-inline-flex"><em class="icon ni ni-invest"></em> <span><?php echo e(__("View Investment")); ?></span></a>
                <a href="<?php echo e(route('admin.investment.list')); ?>" class="btn btn-icon btn-primary d-inline-flex d-sm-none"><em class="icon ni ni-invest"></em></a>
            </div>
        </div>
    </div>
    <div class="nk-block">
        <div class="row g-gs">
            <div class="col-md-6 col-xxl-4">
                <div class="card card-bordered card-full">
                    <div class="card-inner">
                        <div class="card-title-group mb-2">
                            <div class="card-title">
                                <h6 class="title"><?php echo e(__("Actived Investment")); ?></h6>
                                <p><?php echo e(__("The amount of investment currently actived.")); ?></p>
                            </div>
                        </div>
                        <div class="card-amount">
                            <div class="amount"><?php echo e(to_amount(data_get($activeInvest, 'amount'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></div>
                            <div class="amount-sm"><?php echo e(to_amount(data_get($activeInvest, 'since.amount'), $currency)); ?> <small><?php echo e(__("since last week")); ?></small></div>
                        </div>
                        <div class="card-stats mt-4 pb-3">
                            <div class="card-stats-group g-2">
                                <div class="card-stats-data">
                                    <div class="title"><?php echo e(__("Profit to Pay")); ?> <em class="card-hint icon ni ni-help fs-12px" data-toggle="tooltip" data-placement="top" title="<?php echo e(__("The aprox profit amount need to pay based on actived investment.")); ?>"></em></div>
                                    <div class="amount lg"><?php echo e(to_amount(data_get($activeInvest, 'profit'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></div>
                                </div>
                                <div class="card-stats-data">
                                    <div class="title"><?php echo e(__("Active Plans")); ?></div>
                                        <div class="amount lg">
                                            <?php echo e(data_get($activeInvest, 'plan')); ?>

                                            <?php if( data_get($activeInvest, 'diff.plan') !== 0 ): ?>
                                                <span class="change <?php echo e(data_get($activeInvest, 'diff.plan') > 0 ? 'up' : 'down'); ?> tipinfo" title="<?php echo e(__("Than last week")); ?>">
                                                <em class="icon ni ni-arrow-long-<?php echo e(data_get($activeInvest, 'diff.plan') > 0 ? 'up' : 'down'); ?>"></em><?php echo e(abs(data_get($activeInvest, 'diff.plan'))); ?>%</span>
                                            <?php endif; ?>
                                        </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-stats-ck-full h-150px border-bottom border-primary">
                            <?php if($renderIvGraph): ?>
                            <canvas class="chart-minibar" id="activeInvestment"></canvas>
                            <?php endif; ?>
                        </div>
                        <div class="card-stats-ck-label mb-n1 mt-0 pt-1 border-top border-primary">
                            <div class="chart-label"><?php echo e(data_get($ivGraphDate, 'start')); ?></div>
                            <div class="chart-label"><?php echo e(data_get($ivGraphDate, 'end')); ?></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-xxl-4">
                <div class="card card-bordered card-full">
                    <div class="card-inner">
                        <div class="card-title-group mb-1">
                            <div class="card-title">
                                <h6 class="title"><?php echo e(__("Actived Investment Plan")); ?></h6>
                                <p><?php echo e(__("The invested plans that currently actived.")); ?></p>
                            </div>
                        </div>
                        <div class="nk-ovb">
                            <?php if(!empty($activePlans)): ?>
                            <div class="nk-ovb-ck-dnut pt-2 pb-3">
                                <?php if(!empty($plans)): ?>
                                <canvas class="chart-dnut" id="activeInvestPlans"></canvas>
                                <?php endif; ?>
                            </div>
                            <div class="nk-ovb-group g-2">
                                <?php $__currentLoopData = $activePlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="nk-ovb-data">
                                    <div class="title">
                                        <span class="dot dot-lg sq" data-bg="<?php echo e($data['color']); ?>"></span>
                                        <span><?php echo e($name); ?></span>
                                    </div>
                                    <div class="amount"><?php echo e($data['count']); ?> <small><?php echo e($data['percentage']); ?>%</small></div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php else: ?>
                            <div class="no-result pt-5 pb-5 px-1 text-center d-block">
                                <span class="text-soft font-italic small"><?php echo e(__("Available data is not enough to display chart.")); ?></span>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-xxl-4">
                <div class="card card-bordered card-full">
                    <div class="card-inner">
                        <div class="card-title-group mb-1">
                            <div class="card-title">
                                <h6 class="title"><?php echo e(__("Investment Overview")); ?></h6>
                                <p><?php echo e(__("The overview of investment.")); ?> <a href="<?php echo e(route('admin.investment.list')); ?>"><?php echo e(__("View Investment")); ?></a></p>
                            </div>
                        </div>
                        <ul class="nav nav-tabs nav-tabs-card nav-tabs-xs">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#thismonth"><?php echo e(__("This Month")); ?></a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#thisyear"><?php echo e(__("This Year")); ?></a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#alltime"><?php echo e(__("All Time")); ?></a>
                            </li>
                        </ul>
                        <div class="tab-content mt-0">
                            <div class="tab-pane active" id="thismonth">
                                <div class="nk-ivo gy-2">
                                    <div class="subtitle"><?php echo e(__("Total Investment")); ?></div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'month.amount'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span>
                                            <?php if(data_get($stats, 'month.diff.amount') !== 0): ?>
                                                <span class="change <?php echo e(data_get($stats, 'month.diff.amount') > 0 ? 'up' : 'down'); ?> tipinfo" title="Than last month">
                                                <em class="icon ni ni-arrow-long-<?php echo e(data_get($stats, 'month.diff.amount') > 0 ? 'up' : 'down'); ?>"></em><?php echo e(abs(data_get($stats, 'month.diff.amount'))); ?>%</span>
                                            <?php endif; ?>
                                            </div>
                                            <div class="title"><?php echo e(__("Investment Amount")); ?></div>
                                        </div>
                                        <div class="nk-ivo-stats">
                                            <div class="amount"><?php echo e(data_get($stats, 'month.plan')); ?>

                                            <?php if(data_get($stats, 'month.diff.plan') !== 0): ?>
                                                <span class="change <?php echo e(data_get($stats, 'month.diff.plan') > 0 ? 'up' : 'down'); ?> tipinfo" title="Than last month">
                                                <em class="icon ni ni-arrow-long-<?php echo e(data_get($stats, 'month.diff.plan') > 0 ? 'up' : 'down'); ?>"></em><?php echo e(abs(data_get($stats, 'month.diff.plan'))); ?>%</span>
                                            <?php endif; ?>
                                            </div>
                                            <div class="title"><?php echo e(__("Plans")); ?></div>
                                        </div>
                                    </div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount">
                                                <?php echo e(to_amount(data_get($stats, 'month.profit'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span>
                                            </div>
                                            <div class="title"><?php echo e(__("Paid Profit")); ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="nk-ivo gy-2">
                                    <div class="subtitle"><?php echo e(__("Investment in Last Month")); ?></div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'month.last.amount'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></div>
                                            <div class="title"><?php echo e(__("Investment Amount")); ?></div>
                                        </div>
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'month.last.profit'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></div>
                                            <div class="title"><?php echo e(__("Paid Profit")); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="thisyear">
                                <div class="nk-ivo gy-2">
                                    <div class="subtitle"><?php echo e(__("Total Investment")); ?></div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'year.amount'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span>
                                            <?php if(data_get($stats, 'year.diff.amount') !== 0): ?>
                                                <span class="change <?php echo e(data_get($stats, 'year.diff.amount') > 0 ? 'up' : 'down'); ?> tipinfo" title="Than last month">
                                                <em class="icon ni ni-arrow-long-<?php echo e(data_get($stats, 'year.diff.amount') > 0 ? 'up' : 'down'); ?>"></em><?php echo e(abs(data_get($stats, 'year.diff.amount'))); ?>%</span>
                                            <?php endif; ?>
                                            </div>
                                            <div class="title"><?php echo e(__("Investment Amount")); ?></div>
                                        </div>
                                        <div class="nk-ivo-stats">
                                            <div class="amount"><?php echo e(data_get($stats, 'year.plan')); ?>

                                            <?php if(data_get($stats, 'year.diff.plan') !== 0): ?>
                                                <span class="change <?php echo e(data_get($stats, 'year.diff.plan') > 0 ? 'up' : 'down'); ?> tipinfo" title="Than last month">
                                                <em class="icon ni ni-arrow-long-<?php echo e(data_get($stats, 'year.diff.plan') > 0 ? 'up' : 'down'); ?>"></em><?php echo e(abs(data_get($stats, 'year.diff.plan'))); ?>%</span>
                                            <?php endif; ?>
                                            </div>
                                            <div class="title"><?php echo e(__("Plans")); ?></div>
                                        </div>
                                    </div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount">
                                                <?php echo e(to_amount(data_get($stats, 'year.profit'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span>
                                            </div>
                                            <div class="title"><?php echo e(__("Paid Profit")); ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="nk-ivo gy-2">
                                    <div class="subtitle"><?php echo e(__("Investment in Last Year")); ?></div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'year.last.amount'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></div>
                                            <div class="title"><?php echo e(__("Investment Amount")); ?></div>
                                        </div>
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'year.last.profit'), $currency)); ?> <span class="currency"><?php echo e($currency); ?></span></div>
                                            <div class="title"><?php echo e(__("Paid Profit")); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="alltime">
                                <div class="nk-ivo gy-2">
                                    <div class="subtitle"><?php echo e(__("Total Investment")); ?></div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'all.amount'), $currency)); ?>

                                            <span class="currency"><?php echo e($currency); ?></span></div>
                                            <div class="title"><?php echo e(__("Investment Amount")); ?></div>
                                        </div>
                                        <div class="nk-ivo-stats">
                                            <div><span class="amount"><?php echo e(data_get($stats, 'all.plan')); ?></span></div>
                                            <div class="title"><?php echo e(__("Plans")); ?></div>
                                        </div>
                                    </div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'all.profit'), $currency)); ?>

                                            <span class="currency"><?php echo e($currency); ?></span></div>
                                            <div class="title"><?php echo e(__("Paid Profit")); ?></div>
                                        </div>
                                    </div>
                                </div>
                                <div class="nk-ivo gy-2">
                                    <div class="subtitle"><?php echo e(__("Investment in This Year")); ?></div>
                                    <div class="nk-ivo-data">
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'year.amount'), $currency)); ?>

                                            <span class="currency"><?php echo e($currency); ?></span></div>
                                            <div class="title"><?php echo e(__("Investment Amount")); ?></div>
                                        </div>
                                        <div class="nk-ivo-info">
                                            <div class="amount"><?php echo e(to_amount(data_get($stats, 'year.profit'), $currency)); ?>

                                            <span class="currency"><?php echo e($currency); ?></span></div>
                                            <div class="title"><?php echo e(__("Paid Profit")); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6 col-xxl-4">
                <div class="card card-bordered card-full">
                    <div class="card-inner pb-0">
                        <div class="card-title-group mb-3">
                            <div class="card-title">
                                <h6 class="title"><?php echo e(__("Top Invested Scheme")); ?></h6>
                                <p><?php echo e(__("In last 30 days top invested plans.")); ?></p>
                            </div>
                            <div class="card-tools mt-n4 mr-n1">
                                <div class="drodown">
                                    <a href="#" class="dropdown-toggle btn btn-icon btn-trigger" data-toggle="dropdown"><em class="icon ni ni-more-h"></em></a>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        <ul class="link-list-opt no-bdr">
                                            <li><a href="<?php echo e(route('admin.investment.list')); ?>">
                                                <em class="icon ni ni-invest"></em><span><?php echo e(__("View Active Plan")); ?></span>
                                            </a></li>
                                            <li><a href="<?php echo e(route('admin.investment.schemes')); ?>">
                                                <em class="icon ni ni-cards"></em><span><?php echo e(__("View All Schemes")); ?></span>
                                            </a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if(!empty($topPlans)): ?>
                        <div class="progress-list gy-3">
                            <?php $__currentLoopData = $topPlans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="progress-wrap">
                                <div class="progress-text">
                                    <div class="progress-label"><?php echo e($name); ?></div>
                                    <div class="progress-amount"><?php echo e($data['count']); ?></div>
                                </div>
                                <div class="progress progress-md">
                                    <div class="progress-bar" data-progress="<?php echo e($data['percentage']); ?>"></div>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php else: ?>
                        <div class="no-result pt-2 pb-4 px-1 text-center d-block">
                            <span class="text-soft font-italic small"><?php echo e(__("Available data is not enough to display chart.")); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php if($renderTopSchemeGraph): ?>
                    <div class="nk-ivo-ck mt-auto">
                        <canvas class="chart-liner" id="topInvestPlan"></canvas>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="col-md-12 col-xxl-8">
                <div class="card card-bordered card-full">
                    <div class="card-inner border-bottom">
                        <div class="card-title-group">
                            <div class="card-title">
                                <h6 class="title"><?php echo e(__("Recent Investment")); ?></h6>
                            </div>
                            <div class="card-tools">
                                <a href="<?php echo e(route('admin.investment.list')); ?>" class="link"><?php echo e(__("View All")); ?></a>
                            </div>
                        </div>
                    </div>
                    <div class="nk-tb-list">
                        <div class="nk-tb-item nk-tb-head">
                            <div class="nk-tb-col"><span><?php echo e(__("Plan")); ?></span></div>
                            <div class="nk-tb-col tb-col-sm"><span><?php echo e(__("Investor")); ?></span></div>
                            <div class="nk-tb-col tb-col-lg"><span><?php echo e(__("Date")); ?></span></div>
                            <div class="nk-tb-col"><span><?php echo e(__("Amount")); ?></span></div>
                            <div class="nk-tb-col tb-col-sm"><span>&nbsp;</span></div>
                            <div class="nk-tb-col"><span>&nbsp;</span></div>
                        </div>
                        <?php if(filled($recent)): ?>
                        <?php $__currentLoopData = $recent; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $iv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="nk-tb-item">
                            <div class="nk-tb-col">
                                <div class="align-center">
                                    <div class="user-avatar user-avatar-sm bg-light">
                                        <span><?php echo e($iv->code); ?></span>
                                    </div>
                                    <span class="tb-sub ml-2"><?php echo e($iv->scheme['name']); ?>

                                    <span class="d-none d-md-inline">- <?php echo e($iv->calc_details); ?></span></span>
                                </div>
                            </div>
                            <div class="nk-tb-col tb-col-sm">
                                <div class="user-card">
                                    <?php echo user_avatar($iv->user, 'xs'); ?>

                                    <div class="user-name">
                                        <span class="tb-lead"><?php echo e($iv->user->name); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="nk-tb-col tb-col-lg">
                                <span class="tb-sub"><?php echo e(show_date($iv->order_at)); ?></span>
                            </div>
                            <div class="nk-tb-col">
                                <span class="tb-sub tb-amount"><?php echo e($iv->total); ?>

                                <span><?php echo e($currency); ?></span></span>
                            </div>
                            <div class="nk-tb-col tb-col-sm">
                                <?php if($iv->status === InvestmentStatus::ACTIVE): ?>
                                <div class="progress progress-sm w-80px">
                                    <div class="progress-bar" data-progress="<?php echo e($iv->progress); ?>"></div>
                                </div>
                                <?php elseif($iv->status === InvestmentStatus::PENDING): ?>
                                    <span class="badge badge-dim badge-warning"><?php echo e(__("Pending")); ?></span>
                                <?php elseif($iv->status === InvestmentStatus::COMPLETED): ?>
                                    <span class="badge badge-dim badge-success"><?php echo e(__("Completed")); ?></span>
                                <?php elseif($iv->status === InvestmentStatus::CANCELLED): ?>
                                    <span class="badge badge-dim badge-danger"><?php echo e(__("Cancelled")); ?></span>
                                <?php endif; ?>
                            </div>
                            <div class="nk-tb-col nk-tb-col-action">
                                <a class="text-soft btn btn-sm btn-icon btn-trigger" href="<?php echo e(route('admin.investment.details', the_hash($iv->id))); ?>">
                                    <em class="icon ni ni-chevron-right"></em>
                                </a>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <div class="no-result py-1 px-4 d-block">
                            <span class="text-soft font-italic small"><?php echo e(__("No recent investment available!")); ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<?php if($renderIvGraph || $renderTopSchemeGraph || !empty($plans)): ?>
<script type="text/javascript">
    <?php if($renderIvGraph): ?>
    var activeInvestment = {
        tooltip: true,
        tooltipStyle: 'single',
        labels: <?php echo json_encode(array_keys($ivGraph), 15, 512) ?>,
        dataUnit: "<?php echo e($currency); ?>",
        lineTension: .3,
        datasets: [{ label: "<?php echo e(__("Invest")); ?>", color: "#798bff", background: 'solid', borderWidth: 2, data: <?php echo json_encode(array_values($ivGraph), 15, 512) ?> }],
    };
    <?php endif; ?>

    <?php if($renderTopSchemeGraph): ?>
    var topInvestPlan = {   
        tooltip: true,
        tooltipStyle: 'single',
        legend: false,
        labels: <?php echo json_encode(array_keys($topSchemeGraph), 15, 512) ?>,
        dataUnit: 'Plan',
        showDots: false,
        stacked: false,
        lineTension: .5,
        datasets: [{ label: "<?php echo e(__("Invested")); ?>", color: "#816bff", background: 'gradient', borderWidth: 3, data: <?php echo json_encode(array_values($topSchemeGraph), 15, 512) ?> }]
    };
    <?php endif; ?>

    <?php if(!empty($plans)): ?>
    var activeInvestPlans = {
        labels: <?php echo json_encode($plans["name"], 15, 512) ?>,
        dataUnit: 'Plan',
        legend: false,
        datasets: [{ borderColor: '#fff', background: <?php echo json_encode($plans["colors"], 15, 512) ?>, data: <?php echo json_encode($plans["data"], 15, 512) ?> }]
    };
    <?php endif; ?>
</script>
<?php endif; ?>
<script src="<?php echo e(asset('assets/js/charts.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/investment/admin/dashboard.blade.php ENDPATH**/ ?>