<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="js">

<head>
    <meta charset="utf-8">
    <meta name="author" content="Softnio">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="shortcut icon" href="<?php echo e(asset('favicon.ico')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(site_info('name')); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/apps-admin.css?ver=1.0.0')); ?>">
<?php if(sys_settings('ui_theme_skin_admin', 'default') != 'default'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/skins/theme-'.sys_settings('ui_theme_skin_admin').'.css?ver=1.0.0')); ?>">
<?php endif; ?>
</head>

<body class="nk-body npc-cryptlite">
<div class="nk-app-root">
    <div class="nk-main">
        <div class="nk-wrap">

            <div class="nk-header nk-header-fluid nk-header-fixed is-light">
                <div class="container-fluid">
                    <div class="nk-header-wrap">
                        <div class="nk-header-brand">
                            <a href="<?php echo e(route('admin.dashboard')); ?>" class="logo-link">
                                <img class="logo-light logo-img" src="<?php echo e(asset('/images/logo.png')); ?>" srcset="<?php echo e(asset('/images/logo2x.png 2x')); ?>" alt="<?php echo e(site_info('name')); ?>">
                                <img class="logo-dark logo-img" src="<?php echo e(asset('/images/logo-dark.png')); ?>" srcset="<?php echo e(asset('/images/logo-dark2x.png 2x')); ?>" alt="<?php echo e(site_info('name')); ?>">
                            </a>
                        </div>

                        <div class="nk-header-tools">
                            <ul class="nk-quick-nav">
                                <li class="dropdown user-dropdown">
                                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                                        <div class="user-toggle">
                                            <div class="user-avatar sm">
                                                <em class="icon ni ni-user-alt"></em>
                                            </div>
                                            <div class="user-info d-none d-md-block">
                                                <div class="user-status"><?php echo e(__("Administrator")); ?></div>
                                                <div class="user-name dropdown-indicator"><?php echo e(auth()->user()->display_name ?? ''); ?></div>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="dropdown-menu dropdown-menu-md dropdown-menu-right dropdown-menu-s1">
                                        <div class="dropdown-inner user-card-wrap bg-lighter d-none d-md-block">
                                            <div class="user-card">
                                                <div class="user-avatar">
                                                    <span><?php echo user_avatar(auth()->user()); ?></span>
                                                </div>
                                                <div class="user-info">
                                                    <span class="lead-text"><?php echo e(auth()->user()->display_name); ?></span>
                                                    <span class="sub-text"><?php echo e(auth()->user()->email); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="dropdown-inner">
                                            <ul class="link-list">
                                                <li><a href="<?php echo e(route('admin.profile.view')); ?>"><em class="icon ni ni-user-alt"></em><span><?php echo e(__("View Profile")); ?></span></a></li>
                                                <li><a href="<?php echo e(route('admin.profile.view', ['settings'])); ?>"><em class="icon ni ni-setting-alt"></em><span><?php echo e(__("Account Setting")); ?></span></a></li>
                                                <li><a href="<?php echo e(route('admin.profile.view', ['activity'])); ?>"><em class="icon ni ni-activity-alt"></em><span><?php echo e(__("Login Activity")); ?></span></a></li>
                                            </ul>
                                        </div>
                                        <div class="dropdown-inner">
                                            <ul class="link-list">
                                                <li>
                                                    <a href="<?php echo e(route('auth.logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                                    <em class="icon ni ni-signout"></em><spean><?php echo e(__('Sign out')); ?></spean></a>
                                                </li>
                                            </ul>
                                            <form id="logout-form" action="<?php echo e(route('auth.logout')); ?>" method="POST" style="display: none;">
                                                <?php echo csrf_field(); ?>
                                            </form>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <div class="nk-content">
                <div class="container-xl wide-lg">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>

            <div class="nk-footer">
                <div class="container wide-lg">
                    <div class="row g-3">
                        <div class="col-lg-12">
                            <div class="nk-block-content text-center text-lg-center">
                                <p class="text-soft"><?php echo 'Copyright &copy; Investorm 2021. All Rights Reserved.'; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<script src="<?php echo e(asset('assets/js/bundle.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/app.admin.js')); ?>"></script>
<?php echo $__env->yieldPushContent('scripts'); ?>

</body>
</html><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/admin/layouts/minimal.blade.php ENDPATH**/ ?>