
<?php $__env->startSection('title', __('Investment Settings')); ?>

<?php
$base_currency = base_currency();
$alter_currency = secondary_currency();
$all_days = ['mon', 'tue', 'wed', 'thu', 'fri', 'sat', 'sun'];
?>

<?php $__env->startSection('content'); ?>
    <div class="nk-content-body">
        <div class="nk-block-head nk-block-head-sm">
            <div class="nk-block-between">
                <div class="nk-block-head-content">
                    <h3 class="nk-block-title page-title"><?php echo e(__('Investment Settings')); ?></h3>
                    <p><?php echo e(__('Manage your investment settings of the application.')); ?></p>
                </div>
                <div class="nk-block-head-content">
                    <ul class="nk-block-tools gx-1">
                        <li class="d-lg-none">
                            <a href="#" class="btn btn-icon btn-trigger toggle" data-target="pageSidebar"><em class="icon ni ni-menu-right"></em></a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="nk-block card card-bordered">
            <div class="card-inner">
                <form action="<?php echo e(route('admin.settings.investment.save')); ?>" class="form-settings" method="POST">
                    <h5 class="title"><?php echo e(__('Plan Purchase Option')); ?></h5>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label" for="plan-ordered"><?php echo e(__('Show Plan/Scheme by Order')); ?></label>
                                    <span class="form-note"><?php echo e(__('Set the order to display plan/scheme for investment.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap w-max-225px">
                                        <select name="plan_order" class="form-select" id="plan-ordered">
                                            <option value="default"<?php echo e((sys_settings('iv_plan_order') == 'default') ? ' selected' : ''); ?>><?php echo e(__('Default')); ?></option>
                                            <option value="reverse"<?php echo e((sys_settings('iv_plan_order') == 'reverse') ? ' selected' : ''); ?>><?php echo e(__('Reverse')); ?></option>
                                            <option value="random"<?php echo e((sys_settings('iv_plan_order') == 'random') ? ' selected' : ''); ?>><?php echo e(__('Random')); ?></option>
                                            <option value="featured"<?php echo e((sys_settings('iv_plan_order') == 'featured') ? ' selected' : ''); ?>><?php echo e(__('Featured')); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Display Total Return in Percent')); ?></label>
                                    <span class="form-note"><?php echo e(__('Show total return value (%) in plan purchase.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input class="switch-option-value" type="hidden" name="plan_total_percent" value="<?php echo e(sys_settings('iv_plan_total_percent') ?? 'yes'); ?>">
                                        <input id="display-total-return" type="checkbox" class="custom-control-input switch-option"
                                               data-switch="yes"<?php echo e((sys_settings('iv_plan_total_percent', 'yes') == 'yes') ? ' checked=""' : ''); ?>>
                                        <label for="display-total-return" class="custom-control-label"><?php echo e(__('Show')); ?></label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Display Plan Description')); ?></label>
                                    <span class="form-note"><?php echo e(__('Show short description for each plan in purchase.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input class="switch-option-value" type="hidden" name="plan_desc_show" value="<?php echo e(sys_settings('iv_plan_desc_show') ?? 'yes'); ?>">
                                        <input id="display-description" type="checkbox" class="custom-control-input switch-option"
                                               data-switch="yes"<?php echo e((sys_settings('iv_plan_desc_show', 'no') == 'yes') ? ' checked=""' : ''); ?>>
                                        <label for="display-description" class="custom-control-label"><?php echo e(__('Show')); ?></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row g-2 align-start">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Investment Page Headings')); ?></label>
                                    <span class="form-note"><?php echo e(__('Update investment plan page headings.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group mb-3">
                                    <div class="form-control-wrap w-max-350px">
                                        <input type="text" class="form-control" name="plan_pg_heading" value="<?php echo e(sys_settings('iv_iv_plan_pg_heading', 'Investment Plans')); ?>">
                                    </div>
                                    <div class="form-note mt-1"><?php echo e(__('Main Heading')); ?> <span class="pl-2"><?php echo e(__("Eg. :content", ['content' => __("Investment Plans")])); ?></span></div>
                                </div>
                                <div class="form-group mb-3">
                                    <div class="form-control-wrap w-max-350px">
                                        <input type="text" class="form-control" name="plan_pg_title" value="<?php echo e(sys_settings('iv_plan_pg_title', 'Choose your favourite plan and start earning now.')); ?>">
                                    </div>
                                    <div class="form-note mt-1"><?php echo e(__('Title')); ?> <span class="pl-2"><?php echo e(__("Eg. :content", ['content' => __("Choose your favourite plan and start earning now.")])); ?></span></div>
                                </div>
                                <div class="form-group">
                                    <div class="form-control-wrap w-max-500px">
                                        <textarea class="form-control textarea-sm" name="plan_pg_text"><?php echo e(sys_settings('iv_plan_pg_text', 'Here is our several investment plans. You can invest daily, weekly or monthly and get higher returns in your investment.')); ?></textarea> 
                                    </div>
                                    <div class="form-note mt-1"><?php echo e(__('Intro Content')); ?> <span class="pl-2"><?php echo e(__("Eg. :content", ['content' => __("Here is our several investment plans. You can invest daily, weekly or monthly and get higher returns in your investment.")])); ?></span></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    

                    <div class="divider"></div>
                    <div class="form-sets gy-3 wide-md">
                        <h5 class="title"><?php echo e(__('Profit Adjustment')); ?></h5>

                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Adjust Profit / Interest')); ?></label>
                                    <span class="form-note"><?php echo e(__('How do you want to adjust profit into account / ledger.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap w-225px">
                                        <select class="form-select" name="profit_payout">
                                            <option value="everytime"<?php echo e((sys_settings('iv_profit_payout', 10)=='everytime') ? ' selected' : ''); ?>><?php echo e(__("Each Times")); ?></option>
                                            <option value="threshold"<?php echo e((sys_settings('iv_profit_payout', 10)=='threshold') ? ' selected' : ''); ?>><?php echo e(__("Threshold Amount")); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Specify Threshold Amount')); ?></label>
                                    <span class="form-note"><?php echo e(__('Set an amount that consider for auto adjustment.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap w-225px">
                                        <div class="form-text-hint"><span><?php echo e(base_currency()); ?></span></div>
                                        <input type="number" class="form-control" name="profit_payout_amount" value="<?php echo e(sys_settings('iv_profit_payout_amount')); ?>">
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="notes">
                                    <p class="mb-1"><strong><?php echo e(__("Note:")); ?></strong></p>
                                    <ul>
                                        <li class="alert-note is-plain text-soft">
                                            <em class="icon ni ni-info"></em>
                                            <p><strong class="text-dark"><?php echo e(__("Each Times")); ?></strong>: <?php echo e(__("Each time calculate the profit against any plan and adjust into investment account with admin action.")); ?></p>
                                        </li>
                                        <li class="alert-note is-plain text-soft">
                                            <em class="icon ni ni-info"></em>
                                            <p><strong class="text-dark"><?php echo e(__("Threshold Amount")); ?></strong>: <?php echo e(__("Adjust the investment account balance once calculated profits cross the amount specify above.")); ?></p>
                                        </li>
                                        <li class="alert-note is-plain text-danger">
                                            <em class="icon ni ni-alert"></em>
                                            <p><strong><?php echo e(__("Caution")); ?></strong>: <?php echo e(__("Always admin action required to paid the profits from Invest Statement->Profit/Interest Logs to Paid to Profit.")); ?></p>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="divider"></div>
                    <div class="form-sets gy-3 wide-md">
                        <h5 class="title"><?php echo e(__('Advanced Setting')); ?></h5>
                        

                        

                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Start After Admin Confirm')); ?></label>
                                    <span class="form-note"><?php echo e(__('Require or not admin confirmation to start investment plan.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input class="switch-option-value" type="hidden" name="admin_confirmtion" value="<?php echo e(sys_settings('iv_admin_confirmtion') ?? 'yes'); ?>">
                                        <input id="admin-confirmtion" type="checkbox" class="custom-control-input switch-option"
                                               data-switch="yes"<?php echo e((sys_settings('iv_admin_confirmtion', 'yes') == 'yes') ? ' checked=""' : ''); ?>>
                                        <label for="admin-confirmtion" class="custom-control-label"><?php echo e(__('Enable')); ?></label>
                                    </div>
                                    <span class="form-note mt-1"><em class="text-info"><?php echo e(__('If not enable, the plan will start automatically after cancel timeout.')); ?></em></span>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 align-center">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Cancel Subscribtion after Purchase')); ?></label>
                                    <span class="form-note"><?php echo e(__('User allow to cancel the new subscription within time.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap w-225px">
                                        <select class="form-select" name="cancel_timeout">
                                            <option value="yes"<?php echo e((sys_settings('iv_cancel_timeout', 15)==='yes') ? ' selected' : ''); ?>><?php echo e(__("Yes")); ?></option>
                                            <?php for($i=0; $i <=12; $i++): ?>
                                            <option value="<?php echo e(($i * 5)); ?>"<?php echo e((sys_settings('iv_cancel_timeout', 15)===($i * 5)) ? ' selected' : ''); ?>><?php echo e(($i==0) ? 'No' : ($i * 5).' Min'); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 align-start">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Disable New Plan Purchase')); ?></label>
                                    <span class="form-note"><?php echo e(__('Temporarily disable the investment purchase feature.')); ?><br><?php echo e(__('It does not affect on any old or running investment plan.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                        <input class="switch-option-value" type="hidden" name="disable_purchase" value="<?php echo e(sys_settings('iv_disable_purchase') ?? 'no'); ?>">
                                        <input id="purchase-disable" type="checkbox" class="custom-control-input switch-option"
                                               data-switch="yes"<?php echo e((sys_settings('iv_disable_purchase', 'no') == 'yes') ? ' checked=""' : ''); ?>>
                                        <label for="purchase-disable" class="custom-control-label"><?php echo e(__('Disable')); ?></label>
                                    </div>
                                    <span class="form-note mt-1"><em class="text-danger"><?php echo e(__('Users unable to purchase new plan if disable.')); ?></em></span>
                                </div>
                            </div>
                        </div>

                        <div class="row g-3 align-start">
                            <div class="col-md-5">
                                <div class="form-group">
                                    <label class="form-label"><?php echo e(__('Display Notice to User')); ?></label>
                                    <span class="form-note"><?php echo e(__('Add custom message to show on user-end.')); ?></span>
                                </div>
                            </div>
                            <div class="col-md-7">
                                <div class="form-group">
                                    <div class="form-control-wrap">
                                        <input type="text" class="form-control" name="disable_title" value="<?php echo e(sys_settings('iv_disable_title', 'Temporarily unavailable!')); ?>">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="form-control-wrap">
                                        <textarea class="form-control textarea-sm" name="disable_notice"><?php echo e(sys_settings('iv_disable_notice')); ?></textarea>
                                    </div>
                                    <div class="form-note">
                                        <span><?php echo e(__('This message will display when user going to invest on any plan.')); ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-sets gy-3 wide-md">
                        <div class="row g-3">
                            <div class="col-md-7 offset-lg-5">
                                <div class="form-group mt-2">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="form_type" value="iv-option">
                                    <input type="hidden" name="form_prefix" value="iv">
                                    <button type="button" class="btn btn-primary submit-settings" disabled="">
                                        <span class="spinner-border spinner-border-sm hide" role="status" aria-hidden="true"></span>
                                        <span><?php echo e(__('Update')); ?></span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.modules', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\frank\Desktop\xammp\htdocs\invest1\core_invapp\resources\views/investment/admin/settings/general.blade.php ENDPATH**/ ?>